<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class Restaurant extends Model 
{

    protected $table = 'restaurants';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'phone', 'minimum_charge', 'district_id', 'delivery_cost', 'whatsapp_link', 'image', 'password', 'activated', 'status', 'api_token');

    public function orders()
    {
        return $this->hasMany('App\Model\Order');
    }

    public function district()
    {
        return $this->belongsTo('App\Model\District');
    }

    public function comments()
    {
        return $this->hasMany('App\Model\Comment');
    }

    public function offers()
    {
        return $this->hasMany('App\Model\Offer');
    }

    public function categories()
    {
        return $this->belongsToMany('App\Model\Category');
    }

    public function token()
    {
        return $this->morphedByMany('App\Model\Token');
    }

    public function payments()
    {
        return $this->hasMany('App\Model\Payment');
    }

    public function meals()
    {
        return $this->hasMany('App\Model\Meal');
    }

    public function notification()
    {
        return $this->morphedByMany('App\Model\Notification');
    }

    public function contact()
    {
        return $this->morphedByMany('App\Model\Contact');
    }

}